/**************************************************************************************************
 * Public header file for Radio Register extension to support extended PHY.
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
***************************************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
***********************************************************************************************//*!
**************************************************************************************************/

#ifndef RADIOREGEXTENDED_H_
#define RADIOREGEXTENDED_H_

/************************************************************************************
*************************************************************************************
* Extended PHY definitions
*************************************************************************************
************************************************************************************/

/* OOK Threshold Type */
#define OokThreshType_Fixed    		( 0 << 6 ) 
#define OokThreshType_Peak          ( 1 << 6 ) 
#define OokThreshType_Average       ( 2 << 6 )

/* OOK Peak Threshold Step */
#define OokPeakThreshStep_0_5dB     ( 0 << 3 ) 
#define OokPeakThreshStep_1_0dB  	( 1 << 3 ) 
#define OokPeakThreshStep_1_5dB  	( 2 << 3 ) 
#define OokPeakThreshStep_2_0dB  	( 3 << 3 ) 
#define OokPeakThreshStep_3_0dB  	( 4 << 3 ) 
#define OokPeakThreshStep_4_0dB  	( 5 << 3 ) 
#define OokPeakThreshStep_5_0dB  	( 6 << 3 ) 
#define OokPeakThreshStep_6_0dB  	( 7 << 3 ) 

/* OOK Peak Threshold Dec */ 
#define OokPeakThreshDec_OncePerChip    		( 0 << 0 ) 
#define OokPeakThreshDec_OnceEveryTwoChips  	( 1 << 0 ) 
#define OokPeakThreshDec_OnceEveryFourChips  	( 2 << 0 ) 
#define OokPeakThreshDec_OnceEveryEightChips  	( 3 << 0 ) 
#define OokPeakThreshDec_TwiceEachChip    		( 4 << 0 ) 
#define OokPeakThreshDec_FourEachChip    		( 5 << 0 ) 
#define OokPeakThreshDec_EightEachChip    		( 6 << 0 ) 
#define OokPeakThreshDec_SixteenEachChip    	( 7 << 0 ) 

/* OOK Avg Threshold Filt */ 
#define OokAvgThreshFilt_48    	( 0 << 6 ) 
#define OokAvgThreshFilt_191    ( 1 << 6 ) 
#define OokAvgThreshFilt_382    ( 2 << 6 ) 
#define OokAvgThreshFilt_764    ( 3 << 6 ) 
 
/* Afc Low Beta On/Off */
#define AfcLowBeta_On    	  ( 0x10 ) 
#define AfcLowBeta_Off        ( 0x30 )

/* Sensitivity Boost */
#define NormalSensitivity	( 0x1B )
#define HighSensitivity		( 0x2D )

/* Lna Gain Select */
#define G1					( 1 << 0 )
#define G2					( 2 << 0 )
#define G3					( 3 << 0 )
#define G4					( 4 << 0 )
#define G5					( 5 << 0 )
#define G6					( 6 << 0 )

/* InterPacket Rx Delay */
#define InterPacketRxDelay_0	( 0xC0 )
#define InterPacketRxDelay_1	( 0x00 )
#define InterPacketRxDelay_2	( 0x10 )
#define InterPacketRxDelay_3	( 0x20 )
#define InterPacketRxDelay_4	( 0x30 )
#define InterPacketRxDelay_5	( 0x40 )
#define InterPacketRxDelay_6	( 0x50 )
#define InterPacketRxDelay_7	( 0x60 )
#define InterPacketRxDelay_8	( 0x70 )
#define InterPacketRxDelay_9	( 0x80 )
#define InterPacketRxDelay_A	( 0x90 )
#define InterPacketRxDelay_B	( 0xA0 )

#endif /* RADIOREGEXTENDED_H_ */
